#ifndef WORKER_THREAD_SET_H
#define WORKER_THREAD_SET_H

#include <stdbool.h>

#include "global_types.h"

#include "model/kmodule.h"

typedef void (*kmodule_loaded_callback_t)(kmodule_t *kmodule, error_code_t return_val);

error_code_t worker_thread_set_init(unsigned int max_worker_threads_cnt);

void worker_thread_set_deinit(void);

bool worker_thread_set_can_schedule_something(void);

int worker_thread_set_get_pollfd(void);

error_code_t worker_thread_set_on_event(void);

error_code_t worker_thread_set_start_loading_module(kmodule_t *kmodule, kmodule_loaded_callback_t callback_func);

#endif
